/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.CEADescriptor;
import com.quantumdata.edideditor.DescriptorType;

public class CEASAD
extends CEADescriptor {
    private int byte_0;
    private int byte_1;
    private int byte_2;

    public CEASAD() {
        super(DescriptorType.SHORT_AUDIO_DES, 3);
    }

    public void setAudioFormat(int n) {
        this.byte_0 &= 7;
        this.byte_0 |= n << 3;
        if (n >= 9) {
            this.setReserved("00");
        }
    }

    public int getAudioFormat() {
        return this.byte_0 >> 3;
    }

    public void setMaxNumberChannels(int n) {
        this.byte_0 &= 0xF8;
        this.byte_0 |= n - 1;
    }

    public int getMaxNumberChannels() {
        return (this.byte_0 & 7) + 1;
    }

    public void setSamplingRates(int n) {
        this.byte_1 &= 0;
        this.byte_1 |= n;
    }

    public int getSamplingRates() {
        return this.byte_1;
    }

    public void setBitRate(int n) {
        this.byte_2 &= 0;
        this.byte_2 |= n;
    }

    public int getBitRate() {
        return this.byte_2;
    }

    public void setMaxBitRate(String string) {
        this.byte_2 = 0;
        int n = Integer.parseInt(string, 10);
        this.byte_2 = n / 8;
    }

    public String getMaxBitRate() {
        return Integer.toString(this.byte_2 * 8);
    }

    public String setReserved(String string) {
        String string2 = null;
        int n = string.length();
        if (n > 2) {
            string2 = "Vendor Specific value is too long.";
        } else {
            this.byte_2 = Integer.parseInt(string, 16);
        }
        return string2;
    }

    public String getReserved() {
        return String.format("%02X", this.byte_2);
    }

    public void uploadDescriptorData(String string) {
        this.byte_0 = Integer.parseInt(string.substring(0, 2), 16);
        this.byte_1 = Integer.parseInt(string.substring(2, 4), 16);
        this.byte_2 = Integer.parseInt(string.substring(4, 6), 16);
    }

    public String extractDescriptorData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("%02X", this.byte_0));
        stringBuffer.append(String.format("%02X", this.byte_1));
        stringBuffer.append(String.format("%02X", this.byte_2));
        return stringBuffer.toString();
    }
}

